<!-- 
=======================================================
FILE 1: resources/views/admin/documents/index.blade.php
=======================================================
-->


<?php $__env->startSection('dokuments', 'Kelola Dokumen'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6">
        <a href="<?php echo e(route('admin.documents.create')); ?>"
            class="inline-block bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700">
            <i class="fas fa-plus mr-2"></i> Upload Dokumen
        </a>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr class="text-left text-gray-600 text-sm">
                    <th class="px-6 py-4">Judul</th>
                    <th class="px-6 py-4">Kategori</th>
                    <th class="px-6 py-4">Tipe File</th>
                    <th class="px-6 py-4">Tanggal</th>
                    <th class="px-6 py-4">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-t hover:bg-gray-50">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <?php if($document->file_type == 'pdf'): ?>
                                    <i class="fas fa-file-pdf text-red-600 text-xl mr-3"></i>
                                <?php elseif(in_array($document->file_type, ['doc', 'docx'])): ?>
                                    <i class="fas fa-file-word text-blue-600 text-xl mr-3"></i>
                                <?php elseif(in_array($document->file_type, ['xls', 'xlsx'])): ?>
                                    <i class="fas fa-file-excel text-green-600 text-xl mr-3"></i>
                                <?php else: ?>
                                    <i class="fas fa-file text-gray-600 text-xl mr-3"></i>
                                <?php endif; ?>
                                <div>
                                    <p class="font-semibold"><?php echo e($document->title); ?></p>
                                    <?php if($document->description): ?>
                                        <p class="text-sm text-gray-500"><?php echo e(Str::limit($document->description, 50)); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <span
                                class="px-2 py-1 bg-purple-100 text-purple-800 text-xs rounded"><?php echo e(ucfirst($document->category)); ?></span>
                        </td>
                        <td class="px-6 py-4"><?php echo e(strtoupper($document->file_type)); ?></td>
                        <td class="px-6 py-4 text-sm text-gray-600"><?php echo e($document->created_at->format('d M Y')); ?></td>
                        <td class="px-6 py-4">
                            <a href="<?php echo e(Storage::url($document->file_path)); ?>" target="_blank"
                                class="text-green-600 hover:text-green-800 mr-3" title="Download">
                                <i class="fas fa-download"></i>
                            </a>
                            <form action="<?php echo e(route('admin.documents.destroy', $document->id)); ?>" method="POST" class="inline"
                                onsubmit="return confirm('Yakin ingin menghapus?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-800">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">Belum ada dokumen</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\dpm-polbajep\resources\views\admin\documents\index.blade.php ENDPATH**/ ?>