<!-- File: resources/views/frontend/documents.blade.php -->


<?php $__env->startSection('title', 'Dokumen'); ?>

<?php $__env->startSection('content'); ?>
    <div class="hero-gradient text-white py-20"style="
                                                    background-image: url('<?php echo e(asset('img/Dokumen.jpg')); ?>');
                                                    background-size: cover;
                                                    background-position: center;
                                                    background-repeat: no-repeat;
                                                    background-color: rgba(0, 0, 0, 0.7);
                                                    background-blend-mode: overlay;">
        <div class="container mx-auto px-4 text-center">
            <h1 class="text-5xl font-bold mb-4">Dokumen DPM</h1>
            <p class="text-xl">Akses dokumen dan berkas DPM</p>
        </div>
    </div>

    <section class="py-16">
        <div class="container mx-auto px-4">
            <div class="bg-white rounded-xl shadow-lg overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 text-left text-gray-700 font-semibold">Judul Dokumen</th>
                                <th class="px-6 py-4 text-left text-gray-700 font-semibold">Kategori</th>
                                <th class="px-6 py-4 text-left text-gray-700 font-semibold">Tanggal</th>
                                <th class="px-6 py-4 text-center text-gray-700 font-semibold">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="border-t hover:bg-gray-50">
                                    <td class="px-6 py-4">
                                        <div class="flex items-center space-x-3">
                                            <i class="fas fa-file-pdf text-red-600 text-2xl"></i>
                                            <div>
                                                <p class="font-semibold text-gray-800"><?php echo e($document->title); ?></p>
                                                <?php if($document->description): ?>
                                                    <p class="text-sm text-gray-600"><?php echo e(Str::limit($document->description, 60)); ?>

                                                    </p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4">
                                        <span class="px-3 py-1 bg-purple-100 text-purple-800 rounded-full text-sm">
                                            <?php echo e(ucfirst($document->category)); ?>

                                        </span>
                                    </td>
                                    <td class="px-6 py-4 text-gray-600">
                                        <?php echo e($document->created_at->format('d M Y')); ?>

                                    </td>
                                    <td class="px-6 py-4 text-center">
                                        <a href="<?php echo e(Storage::url($document->file_path)); ?>" target="_blank"
                                            class="inline-block bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition">
                                            <i class="fas fa-download mr-2"></i>Download
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="px-6 py-16 text-center">
                                        <i class="fas fa-file-alt text-6xl text-gray-300 mb-4"></i>
                                        <p class="text-gray-500 text-xl">Belum ada dokumen tersedia</p>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="mt-8">
                <?php echo e($documents->links()); ?>

            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\dpm-polbajep\resources\views\frontend\documents.blade.php ENDPATH**/ ?>