<!-- 
=======================================================
FILE 1: resources/views/admin/structures/index.blade.php
=======================================================
-->


<?php $__env->startSection('struktur', 'Kelola Struktur Organisasi'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6">
        <a href="<?php echo e(route('admin.structures.create')); ?>"
            class="inline-block bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700">
            <i class="fas fa-plus mr-2"></i> Tambah Struktur
        </a>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr class="text-left text-gray-600 text-sm">
                    <th class="px-6 py-4">Foto</th>
                    <th class="px-6 py-4">Nama</th>
                    <th class="px-6 py-4">Jabatan</th>
                    <th class="px-6 py-4">Jurusan</th>
                    <th class="px-6 py-4">Urutan</th>
                    <th class="px-6 py-4">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $structures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-t hover:bg-gray-50">
                        <td class="px-6 py-4">
                            <?php if($structure->photo): ?>
                                <img src="<?php echo e(Storage::url($structure->photo)); ?>" class="w-16 h-16 object-cover rounded-lg">
                            <?php else: ?>
                                <div class="w-16 h-16 bg-gray-200 rounded-lg flex items-center justify-center">
                                    <i class="fas fa-user text-gray-400"></i>
                                </div>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 font-semibold"><?php echo e($structure->name); ?></td>
                        <td class="px-6 py-4"><?php echo e($structure->position); ?></td>
                        <td class="px-6 py-4"><?php echo e($structure->department ?? '-'); ?></td>
                        <td class="px-6 py-4"><?php echo e($structure->order); ?></td>
                        <td class="px-6 py-4">
                            <a href="<?php echo e(route('admin.structures.edit', $structure->id)); ?>"
                                class="text-blue-600 hover:text-blue-800 mr-3">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="<?php echo e(route('admin.structures.destroy', $structure->id)); ?>" method="POST" class="inline"
                                onsubmit="return confirm('Yakin ingin menghapus?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-800">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="px-6 py-8 text-center text-gray-500">Belum ada data struktur</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\dpm-polbajep\resources\views\admin\structures\index.blade.php ENDPATH**/ ?>