<?php

use Illuminate\Auth\Events\Login;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\Admin\NewsController;
use App\Http\Controllers\Admin\ProgramController;
use App\Http\Controllers\Admin\StructureController;
use App\Http\Controllers\Admin\DocumentController;
use App\Http\Controllers\Admin\AspirationController;


Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/tentang', [HomeController::class, 'about'])->name('about');
Route::get('/berita', [HomeController::class, 'news'])->name('news');
Route::get('/berita/{slug}', [HomeController::class, 'newsDetail'])->name('news.detail');
Route::get('/program-kerja', [HomeController::class, 'programs'])->name('programs');
Route::get('/struktur-organisasi', [HomeController::class, 'structure'])->name('structure');
Route::get('/dokumen', [HomeController::class, 'documents'])->name('documents');
Route::get('/aspirasi', [HomeController::class, 'aspiration'])->name('aspiration');
Route::post('/aspirasi', [HomeController::class, 'aspirationStore'])->name('aspiration.store');
Route::get('/kontak', [HomeController::class, 'contact'])->name('contact');
Route::get('/login', [HomeController::class, 'login'])->name('login');


// Admin Routes
Route::prefix('admin')->name('admin.')->middleware(['auth'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    Route::resource('sliders', SliderController::class);
    Route::resource('news', NewsController::class);
    Route::resource('programs', ProgramController::class);
    Route::resource('structures', StructureController::class);
    Route::resource('documents', DocumentController::class);
    Route::get('documents/{document}/download', [DocumentController::class, 'download'])->name('documents.download');
    Route::get('aspirations/export', [AspirationController::class, 'export'])->name('aspirations.export');
    Route::resource('aspirations', AspirationController::class)->only(['index', 'show', 'update', 'destroy']);
    Route::resource('surat-masuk', App\Http\Controllers\Admin\SuratMasukController::class)
        ->names('admin.surat-masuk');
    Route::resource('surat-keluar', App\Http\Controllers\Admin\SuratKeluarController::class)
        ->names('admin.surat-keluar');


});

require __DIR__ . '/auth.php';

// TAMBAHKAN ROUTE INI (setelah auth.php):
Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', function () {
        return redirect()->route('admin.dashboard');
    })->name('dashboard');
    Route::get('/notifications/read', function () {
        auth()->user()->unreadNotifications->markAsRead();
        return back();
    })->name('notifications.read');
});