<!-- File: resources/views/admin/dashboard.blade.php -->
@extends('layouts.admin')

@section('page-title', 'Dashboard')

@section('content')
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <div class="bg-white p-6 rounded-lg shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-500 text-sm">Total Berita</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $news_count }}</p>
                </div>
                <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-newspaper text-blue-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-lg shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-500 text-sm">Aspirasi Pending</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $aspirations_pending }}</p>
                </div>
                <div class="w-12 h-12 bg-yellow-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-comments text-yellow-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-lg shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-500 text-sm">Total Dokumen</p>
                    <p class="text-3xl font-bold text-gray-800">{{ $documents_count }}</p>
                </div>
                <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-file-alt text-green-600 text-xl"></i>
                </div>
            </div>
        </div>

        <div class="bg-white p-6 rounded-lg shadow">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-gray-500 text-sm">Pengunjung</p>
                    <p class="text-3xl font-bold text-gray-800">-</p>
                </div>
                <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-users text-purple-600 text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-semibold text-gray-800">Aspirasi Terbaru</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50">
                    <tr class="text-left text-gray-600 text-sm">
                        <th class="px-6 py-3">Nama</th>
                        <th class="px-6 py-3">Subjek</th>
                        <th class="px-6 py-3">Tanggal</th>
                        <th class="px-6 py-3">Status</th>
                        <th class="px-6 py-3">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($recent_aspirations as $aspiration)
                        <tr class="border-b hover:bg-gray-50">
                            <td class="px-6 py-4">{{ $aspiration->name }}</td>
                            <td class="px-6 py-4">{{ Str::limit($aspiration->subject, 30) }}</td>
                            <td class="px-6 py-4 text-sm text-gray-600">{{ $aspiration->created_at->format('d M Y') }}</td>
                            <td class="px-6 py-4">
                                @if($aspiration->status == 'pending')
                                    <span class="px-2 py-1 bg-yellow-100 text-yellow-800 text-xs rounded">Pending</span>
                                @elseif($aspiration->status == 'process')
                                    <span class="px-2 py-1 bg-blue-100 text-blue-800 text-xs rounded">Proses</span>
                                @else
                                    <span class="px-2 py-1 bg-green-100 text-green-800 text-xs rounded">Selesai</span>
                                @endif
                            </td>
                            <td class="px-6 py-4">
                                <a href="{{ route('admin.aspirations.show', $aspiration->id) }}"
                                    class="text-blue-600 hover:text-blue-800">
                                    <i class="fas fa-eye"></i> Lihat
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-8 text-center text-gray-500">Belum ada aspirasi</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
@endsection