<!-- 
=====================================================
FILE: resources/views/frontend/structure.blade.php
=====================================================
-->
@extends('layouts.frontend')

@section('title', 'Struktur Organisasi DPM')

@section('content')
    <div class="hero-gradient text-white py-20" style="
                    background-image: url('{{ asset('img/DPM.jpg') }}');
                    background-size: cover;
                    background-position: center;
                    background-color: rgba(0, 0, 0, 0.7);
                    background-blend-mode: overlay;
                    background-repeat: no-repeat;">
        <div class="container mx-auto px-4 text-center">
            <h1 class="text-5xl font-bold mb-4">Struktur Organisasi</h1>
            <p class="text-xl">Pengurus DPM Politeknik Balekambang Jepara</p>
        </div>
    </div>

    <section class="py-16 bg-gray-50">
        <div class="container mx-auto px-4">
            @if($structures->count() > 0)
                <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                    @foreach($structures as $structure)
                        <div class="bg-white rounded-xl shadow-lg overflow-hidden card-hover">
                            @if($structure->photo)
                                <img src="{{ Storage::url($structure->photo) }}" class="w-full h-90 sm:h-56 md:h-64 object-cover">
                            @else
                                <div
                                    class="w-full h-64 bg-gradient-to-br from-purple-400 to-purple-600 flex items-center justify-center">
                                    <i class="fas fa-user text-white text-6xl"></i>
                                </div>
                            @endif

                            <div class="p-6 text-center">
                                <h3 class="text-xl font-bold text-gray-800 mb-2">{{ $structure->name }}</h3>
                                <p class="text-purple-600 font-semibold mb-1">{{ $structure->position }}</p>
                                @if($structure->department)
                                    <p class="text-gray-500 text-sm">{{ $structure->department }}</p>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <!-- Empty State -->
                <div class="text-center py-16">
                    <div class="inline-block p-8 bg-white rounded-2xl shadow-lg">
                        <div class="w-32 h-32 mx-auto bg-purple-100 rounded-full flex items-center justify-center mb-6">
                            <i class="fas fa-users text-purple-600 text-6xl"></i>
                        </div>
                        <h3 class="text-2xl font-bold text-gray-800 mb-3">Struktur Organisasi Belum Tersedia</h3>
                        <p class="text-gray-500 text-lg mb-6">Data pengurus DPM akan segera ditambahkan</p>
                        <a href="{{ route('home') }}"
                            class="inline-block bg-purple-600 text-white px-8 py-3 rounded-lg hover:bg-purple-700 transition">
                            <i class="fas fa-home mr-2"></i>Kembali ke Beranda
                        </a>
                    </div>
                </div>
            @endif
        </div>
    </section>

    <!-- Informasi Tambahan -->
    <section class="py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto">
                <div class="text-center mb-12">
                    <h2 class="text-3xl font-bold text-gray-800 mb-4">Hubungi Kami</h2>
                    <p class="text-gray-600 text-lg">Untuk informasi lebih lanjut, silakan hubungi kontak DPM</p>
                </div>

                <div class="grid md:grid-cols-3 gap-6">
                    <div class="bg-gradient-to-br from-purple-50 to-purple-100 p-6 rounded-xl text-center">
                        <div class="w-16 h-16 bg-purple-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-envelope text-white text-2xl"></i>
                        </div>
                        <h3 class="font-bold text-gray-800 mb-2">Email</h3>
                        <p class="text-gray-600">dpmpolibang@gmail.com</p>
                    </div>

                    <div class="bg-gradient-to-br from-blue-50 to-blue-100 p-6 rounded-xl text-center">
                        <div class="w-16 h-16 bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-phone text-white text-2xl"></i>
                        </div>
                        <h3 class="font-bold text-gray-800 mb-2">Telepon</h3>
                        <p class="text-gray-600">085648037418</p>
                    </div>

                    <div class="bg-gradient-to-br from-green-50 to-green-100 p-6 rounded-xl text-center">
                        <div class="w-16 h-16 bg-green-600 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-map-marker-alt text-white text-2xl"></i>
                        </div>
                        <h3 class="font-bold text-gray-800 mb-2">Lokasi</h3>
                        <p class="text-gray-600">Jepara, Jawa Tengah</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection