<!-- File: resources/views/frontend/documents.blade.php -->
@extends('layouts.frontend')

@section('title', 'Dokumen')

@section('content')
    <div class="hero-gradient text-white py-20"style="
                                                    background-image: url('{{ asset('img/Dokumen.jpg') }}');
                                                    background-size: cover;
                                                    background-position: center;
                                                    background-repeat: no-repeat;
                                                    background-color: rgba(0, 0, 0, 0.7);
                                                    background-blend-mode: overlay;">
        <div class="container mx-auto px-4 text-center">
            <h1 class="text-5xl font-bold mb-4">Dokumen DPM</h1>
            <p class="text-xl">Akses dokumen dan berkas DPM</p>
        </div>
    </div>

    <section class="py-16">
        <div class="container mx-auto px-4">
            <div class="bg-white rounded-xl shadow-lg overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-4 text-left text-gray-700 font-semibold">Judul Dokumen</th>
                                <th class="px-6 py-4 text-left text-gray-700 font-semibold">Kategori</th>
                                <th class="px-6 py-4 text-left text-gray-700 font-semibold">Tanggal</th>
                                <th class="px-6 py-4 text-center text-gray-700 font-semibold">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($documents as $document)
                                <tr class="border-t hover:bg-gray-50">
                                    <td class="px-6 py-4">
                                        <div class="flex items-center space-x-3">
                                            <i class="fas fa-file-pdf text-red-600 text-2xl"></i>
                                            <div>
                                                <p class="font-semibold text-gray-800">{{ $document->title }}</p>
                                                @if($document->description)
                                                    <p class="text-sm text-gray-600">{{ Str::limit($document->description, 60) }}
                                                    </p>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4">
                                        <span class="px-3 py-1 bg-purple-100 text-purple-800 rounded-full text-sm">
                                            {{ ucfirst($document->category) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 text-gray-600">
                                        {{ $document->created_at->format('d M Y') }}
                                    </td>
                                    <td class="px-6 py-4 text-center">
                                        <a href="{{ Storage::url($document->file_path) }}" target="_blank"
                                            class="inline-block bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition">
                                            <i class="fas fa-download mr-2"></i>Download
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="px-6 py-16 text-center">
                                        <i class="fas fa-file-alt text-6xl text-gray-300 mb-4"></i>
                                        <p class="text-gray-500 text-xl">Belum ada dokumen tersedia</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="mt-8">
                {{ $documents->links() }}
            </div>
        </div>
    </section>
@endsection