<!-- 
=======================================================
FILE 1: resources/views/admin/structures/index.blade.php
=======================================================
-->
@extends('layouts.admin')

@section('struktur', 'Kelola Struktur Organisasi')

@section('content')
    <div class="mb-6">
        <a href="{{ route('admin.structures.create') }}"
            class="inline-block bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700">
            <i class="fas fa-plus mr-2"></i> Tambah Struktur
        </a>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr class="text-left text-gray-600 text-sm">
                    <th class="px-6 py-4">Foto</th>
                    <th class="px-6 py-4">Nama</th>
                    <th class="px-6 py-4">Jabatan</th>
                    <th class="px-6 py-4">Jurusan</th>
                    <th class="px-6 py-4">Urutan</th>
                    <th class="px-6 py-4">Aksi</th>
                </tr>
            </thead>
            <tbody>
                @forelse($structures as $structure)
                    <tr class="border-t hover:bg-gray-50">
                        <td class="px-6 py-4">
                            @if($structure->photo)
                                <img src="{{ Storage::url($structure->photo) }}" class="w-16 h-16 object-cover rounded-lg">
                            @else
                                <div class="w-16 h-16 bg-gray-200 rounded-lg flex items-center justify-center">
                                    <i class="fas fa-user text-gray-400"></i>
                                </div>
                            @endif
                        </td>
                        <td class="px-6 py-4 font-semibold">{{ $structure->name }}</td>
                        <td class="px-6 py-4">{{ $structure->position }}</td>
                        <td class="px-6 py-4">{{ $structure->department ?? '-' }}</td>
                        <td class="px-6 py-4">{{ $structure->order }}</td>
                        <td class="px-6 py-4">
                            <a href="{{ route('admin.structures.edit', $structure->id) }}"
                                class="text-blue-600 hover:text-blue-800 mr-3">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.structures.destroy', $structure->id) }}" method="POST" class="inline"
                                onsubmit="return confirm('Yakin ingin menghapus?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-800">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-6 py-8 text-center text-gray-500">Belum ada data struktur</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection