<!-- 
=======================================================
FILE 1: resources/views/admin/sliders/index.blade.php
=======================================================
-->
@extends('layouts.admin')

@section('page-title', 'Kelola Slider')

@section('content')
    <div class="mb-6">
        <a href="{{ route('admin.sliders.create') }}"
            class="inline-block bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700">
            <i class="fas fa-plus mr-2"></i> Tambah Slider
        </a>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr class="text-left text-gray-600 text-sm">
                    <th class="px-6 py-4">Gambar</th>
                    <th class="px-6 py-4">Judul</th>
                    <th class="px-6 py-4">Deskripsi</th>
                    <th class="px-6 py-4">Urutan</th>
                    <th class="px-6 py-4">Status</th>
                    <th class="px-6 py-4">Aksi</th>
                </tr>
            </thead>
            <tbody>
                @forelse($sliders as $slider)
                    <tr class="border-t hover:bg-gray-50">
                        <td class="px-6 py-4">
                            @if($slider->image)
                                <img src="{{ Storage::url($slider->image) }}" class="w-20 h-12 object-cover rounded">
                            @else
                                <div class="w-20 h-12 bg-gray-200 rounded"></div>
                            @endif
                        </td>
                        <td class="px-6 py-4 font-semibold">{{ $slider->title }}</td>
                        <td class="px-6 py-4">{{ Str::limit($slider->description, 50) }}</td>
                        <td class="px-6 py-4">{{ $slider->order }}</td>
                        <td class="px-6 py-4">
                            @if($slider->is_active)
                                <span class="px-2 py-1 bg-green-100 text-green-800 text-xs rounded">Aktif</span>
                            @else
                                <span class="px-2 py-1 bg-gray-100 text-gray-800 text-xs rounded">Nonaktif</span>
                            @endif
                        </td>
                        <td class="px-6 py-4">
                            <a href="{{ route('admin.sliders.edit', $slider->id) }}"
                                class="text-blue-600 hover:text-blue-800 mr-3">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.sliders.destroy', $slider->id) }}" method="POST" class="inline"
                                onsubmit="return confirm('Yakin ingin menghapus?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-800">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="px-6 py-8 text-center text-gray-500">Belum ada slider</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection