<!-- 
=======================================================
FILE 1: resources/views/admin/documents/index.blade.php
=======================================================
-->
@extends('layouts.admin')

@section('dokuments', 'Kelola Dokumen')

@section('content')
    <div class="mb-6">
        <a href="{{ route('admin.documents.create') }}"
            class="inline-block bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700">
            <i class="fas fa-plus mr-2"></i> Upload Dokumen
        </a>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr class="text-left text-gray-600 text-sm">
                    <th class="px-6 py-4">Judul</th>
                    <th class="px-6 py-4">Kategori</th>
                    <th class="px-6 py-4">Tipe File</th>
                    <th class="px-6 py-4">Tanggal</th>
                    <th class="px-6 py-4">Aksi</th>
                </tr>
            </thead>
            <tbody>
                @forelse($documents as $document)
                    <tr class="border-t hover:bg-gray-50">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                @if($document->file_type == 'pdf')
                                    <i class="fas fa-file-pdf text-red-600 text-xl mr-3"></i>
                                @elseif(in_array($document->file_type, ['doc', 'docx']))
                                    <i class="fas fa-file-word text-blue-600 text-xl mr-3"></i>
                                @elseif(in_array($document->file_type, ['xls', 'xlsx']))
                                    <i class="fas fa-file-excel text-green-600 text-xl mr-3"></i>
                                @else
                                    <i class="fas fa-file text-gray-600 text-xl mr-3"></i>
                                @endif
                                <div>
                                    <p class="font-semibold">{{ $document->title }}</p>
                                    @if($document->description)
                                        <p class="text-sm text-gray-500">{{ Str::limit($document->description, 50) }}</p>
                                    @endif
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <span
                                class="px-2 py-1 bg-purple-100 text-purple-800 text-xs rounded">{{ ucfirst($document->category) }}</span>
                        </td>
                        <td class="px-6 py-4">{{ strtoupper($document->file_type) }}</td>
                        <td class="px-6 py-4 text-sm text-gray-600">{{ $document->created_at->format('d M Y') }}</td>
                        <td class="px-6 py-4">
                            <a href="{{ Storage::url($document->file_path) }}" target="_blank"
                                class="text-green-600 hover:text-green-800 mr-3" title="Download">
                                <i class="fas fa-download"></i>
                            </a>
                            <form action="{{ route('admin.documents.destroy', $document->id) }}" method="POST" class="inline"
                                onsubmit="return confirm('Yakin ingin menghapus?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-800">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">Belum ada dokumen</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection