<!-- 
=======================================================
FILE 2: resources/views/admin/documents/create.blade.php
=======================================================
-->
@extends('layouts.admin')

@section('dokuments', 'Upload Dokumen')

@section('content')
    <div class="bg-white rounded-lg shadow p-6 max-w-2xl">
        <form action="{{ route('admin.documents.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Judul Dokumen</label>
                <input type="text" name="title" value="{{ old('title') }}"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600 @error('title') border-red-500 @enderror"
                    required>
                @error('title')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Deskripsi (Opsional)</label>
                <textarea name="description" rows="3"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600">{{ old('description') }}</textarea>
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">File Dokumen</label>
                <input type="file" name="file_path" accept=".pdf,.doc,.docx,.xls,.xlsx"
                    class="w-full px-4 py-2 border rounded-lg @error('file_path') border-red-500 @enderror" required>
                <p class="text-sm text-gray-500 mt-1">Format: PDF, DOC, DOCX, XLS, XLSX (Max: 5MB)</p>
                @error('file_path')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 font-semibold mb-2">Kategori</label>
                <select name="category"
                    class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"
                    required>
                    <option value="umum">Umum</option>
                    <option value="laporan">Laporan</option>
                    <option value="peraturan">Peraturan</option>
                    <option value="notulensi">Notulensi</option>
                    <option value="proposal">Proposal</option>
                </select>
            </div>

            <div class="flex space-x-4">
                <button type="submit" class="bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700">
                    <i class="fas fa-upload mr-2"></i> Upload
                </button>
                <a href="{{ route('admin.documents.index') }}"
                    class="bg-gray-500 text-white px-6 py-2 rounded-lg hover:bg-gray-600">
                    Batal
                </a>
            </div>
        </form>
    </div>
@endsection