<!-- 
=======================================================
FILE 4: resources/views/admin/aspirations/show.blade.php
=======================================================
-->
@extends('layouts.admin')

@section('aspirasi', 'Detail Aspirasi')

@section('content')
    <div class="max-w-4xl">
        <div class="bg-white rounded-lg shadow p-6 mb-6">
            <div class="grid md:grid-cols-2 gap-6 mb-6">
                <div>
                    <h3 class="text-sm text-gray-500 mb-1">Nama</h3>
                    <p class="text-lg font-semibold">{{ $aspiration->name }}</p>
                </div>
                <div>
                    <h3 class="text-sm text-gray-500 mb-1">NIM</h3>
                    <p class="text-lg">{{ $aspiration->nim ?? '-' }}</p>
                </div>
                <div>
                    <h3 class="text-sm text-gray-500 mb-1">Email</h3>
                    <p class="text-lg">{{ $aspiration->email }}</p>
                </div>
                <div>
                    <h3 class="text-sm text-gray-500 mb-1">Tanggal</h3>
                    <p class="text-lg">{{ $aspiration->created_at->format('d F Y H:i') }}</p>
                </div>
            </div>

            <div class="border-t pt-6">
                <h3 class="text-sm text-gray-500 mb-1">Subjek</h3>
                <p class="text-xl font-semibold mb-4">{{ $aspiration->subject }}</p>

                <h3 class="text-sm text-gray-500 mb-1">Pesan/Aspirasi</h3>
                <div class="bg-gray-50 p-4 rounded-lg">
                    <p class="text-gray-700 leading-relaxed whitespace-pre-wrap">{{ $aspiration->message }}</p>
                </div>
            </div>
        </div>

        <!-- Form Update Status & Response -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-semibold mb-4">Update Status & Respon</h3>

            <form action="{{ route('admin.aspirations.update', $aspiration->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="mb-6">
                    <label class="block text-gray-700 font-semibold mb-2">Status</label>
                    <select name="status"
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600"
                        required>
                        <option value="pending" {{ $aspiration->status == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="process" {{ $aspiration->status == 'process' ? 'selected' : '' }}>Diproses</option>
                        <option value="done" {{ $aspiration->status == 'done' ? 'selected' : '' }}>Selesai</option>
                    </select>
                </div>

                <div class="mb-6">
                    <label class="block text-gray-700 font-semibold mb-2">Respon/Tindak Lanjut</label>
                    <textarea name="response" rows="5"
                        class="w-full px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-600">{{ old('response', $aspiration->response) }}</textarea>
                    <p class="text-sm text-gray-500 mt-1">Berikan tanggapan atau tindak lanjut untuk aspirasi ini</p>
                </div>

                <div class="flex space-x-4">
                    <button type="submit" class="bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700">
                        <i class="fas fa-save mr-2"></i> Update
                    </button>
                    <a href="{{ route('admin.aspirations.index') }}"
                        class="bg-gray-500 text-white px-6 py-2 rounded-lg hover:bg-gray-600">
                        Kembali
                    </a>
                </div>
            </form>
        </div>
    </div>
@endsection