<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Slider extends Model
{
    use HasFactory;

    /**
     * Nama tabel di database (opsional jika mengikuti konvensi)
     * Laravel otomatis menggunakan 'sliders' (plural dari Slider)
     */
    protected $table = 'sliders';

    /**
     * Kolom yang boleh diisi secara mass assignment
     */
    protected $fillable = [
        'title',
        'description',
        'image',
        'order',
        'is_active'
    ];

    /**
     * Kolom yang tidak boleh diisi secara mass assignment
     */
    // protected $guarded = ['id'];

    /**
     * Casting tipe data
     */
    protected $casts = [
        'is_active' => 'boolean',
        'order' => 'integer',
    ];

    /**
     * Scope query untuk slider aktif
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope query untuk ordering
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('order', 'asc');
    }
}
