<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Aspiration extends Model
{
    use HasFactory;

    protected $table = 'aspirations';

    protected $fillable = [
        'name',
        'nim',
        'email',
        'subject',
        'message',
        'status',
        'response'
    ];

    /**
     * Konstanta untuk status
     */
    const STATUS_PENDING = 'pending';
    const STATUS_PROCESS = 'process';
    const STATUS_DONE = 'done';

    /**
     * Scope untuk status pending
     */
    public function scopePending($query)
    {
        return $query->where('status', self::STATUS_PENDING);
    }

    /**
     * Scope untuk status process
     */
    public function scopeProcess($query)
    {
        return $query->where('status', self::STATUS_PROCESS);
    }

    /**
     * Scope untuk status done
     */
    public function scopeDone($query)
    {
        return $query->where('status', self::STATUS_DONE);
    }

    /**
     * Accessor untuk status label
     */
    public function getStatusLabelAttribute()
    {
        $labels = [
            'pending' => 'Menunggu',
            'process' => 'Diproses',
            'done' => 'Selesai',
        ];

        return $labels[$this->status] ?? $this->status;
    }

    /**
     * Accessor untuk status badge class
     */
    public function getStatusBadgeAttribute()
    {
        $badges = [
            'pending' => 'bg-yellow-100 text-yellow-800',
            'process' => 'bg-blue-100 text-blue-800',
            'done' => 'bg-green-100 text-green-800',
        ];

        return $badges[$this->status] ?? 'bg-gray-100 text-gray-800';
    }

    /**
     * Check if aspiration is responded
     */
    public function isResponded()
    {
        return !empty($this->response);
    }
}